package w83a.w83aBeans;

import java.sql.ResultSet;

import org.apache.commons.lang.StringUtils;

import w83a.util.jdbc.W83aDataBase;
import w83a.w83aDAO.w83aConstantesBD.W83aArbitrosBD;
import w83a.w83aDAO.w83aConstantesBD.W83aBaseBeanBD;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
 


// TODO: Auto-generated Javadoc
/**
 * The Class W83aArbitrosBean.
 * @author a
 */
public class W83aArbitrosBean extends W83aBaseBean implements W83aBaseBeanBD{
	
	/** The Constant serialVersionUID. */
	private static final long	serialVersionUID	= 1L;

	/** The territorio. */
	private String territorio = "";
	
	/** The territorio desc. */
	private String	territorioDesc = "";
	
	/** The dni. */
	private String dni="";
	
	/** The nombre arbitro. */
	private String nombreArbitro="";
	
	/** The baja. */
	private String baja="";


	/**
	 * El constructor de W83aAgrupacionesBean.
	 * 
	 * @param o the o
	 * @param otrosValores the otros valores
	 * @return the object
	 * @throws Exception the exception
	 */
	public Object rowToBean(Object o, Object otrosValores) throws Exception {
		// TODO Auto-generated method stub
		ResultSet rs = (ResultSet)o;//NOPMD
		this.territorio = W83aDataBase.getStringFromRS(rs, W83aArbitrosBD.territorio);
		this.territorioDesc = W83aDataBase.getStringFromRS(rs, W83aArbitrosBD.descTablaTerritorio).toUpperCase();
		this.dni = W83aDataBase.getStringFromRS(rs, W83aArbitrosBD.dni);
		this.nombreArbitro = W83aDataBase.getStringFromRS(rs, W83aArbitrosBD.nombreArbitro).toUpperCase();
		if(StringUtils.isEmpty(W83aDataBase.getStringFromRS(rs, W83aArbitrosBD.baja))){
			this.baja = W83aClsConstantes.ALTA;			
		}else{
			this.baja = W83aClsConstantes.BAJA;
		}
		
		return this;
	}

	/**
	 * Sets the territorio.
	 * 
	 * @param territorio the new territorio
	 */
	public void setTerritorio(String territorio) {
		this.territorio = territorio;
	}

	/**
	 * Gets the territorio.
	 * 
	 * @return the territorio
	 */
	public String getTerritorio() {
		return this.territorio;
	}
	
	/**
	 * Sets the territorio desc.
	 *
	 * @param territorioDesc the new territorio desc
	 */
	public void setTerritorioDesc(String territorioDesc) {
		this.territorioDesc = territorioDesc;
	}

	/**
	 * Gets the territorio desc.
	 *
	 * @return the territorio desc
	 */
	public String getTerritorioDesc() {
		return territorioDesc;
	}

	/**
	 * Gets the nombre territorio.
	 * 
	 * @param pCod the cod
	 * @return the nombre territorio
	 */
	public String getNombreTerritorio(String pCod) {
		String nombreTerritorio;
		if(W83aClsConstantes.CONSTANTE_ALAVA.equalsIgnoreCase(pCod)){
			nombreTerritorio="LAVA/ARABA";
		}else if(W83aClsConstantes.CONSTANTE_GIPUZKOA.equalsIgnoreCase(pCod)){
			nombreTerritorio="GIPUZKOA";
		}else if(W83aClsConstantes.CONSTANTE_BIZKAIA.equalsIgnoreCase(pCod)){
			nombreTerritorio="BIZKAIA";
		}else if(W83aClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equalsIgnoreCase(pCod)){
			nombreTerritorio="SERVICIOS CENTRALES";
		}else{
			nombreTerritorio="";
		}
		return nombreTerritorio;
	}

	/**
	 * Sets the baja.
	 * 
	 * @param baja the new baja
	 */
	public void setBaja(String baja) {
		this.baja = baja;
	}

	/**
	 * Gets the baja.
	 * 
	 * @return the baja
	 */
	public String getBaja() {
		return this.baja;
	}

	/**
	 * Sets the dni.
	 * 
	 * @param dni the new dni
	 */
	public void setDni(String dni) {
		this.dni = dni;
	}

	/**
	 * Gets the dni.
	 * 
	 * @return the dni
	 */
	public String getDni() {
		return this.dni;
	}

	/**
	 * Sets the nombre arbitro.
	 * 
	 * @param nombreArbitro the new nombre arbitro
	 */
	public void setNombreArbitro(String nombreArbitro) {
		this.nombreArbitro = nombreArbitro;
	}

	/**
	 * Gets the nombre arbitro.
	 * 
	 * @return the nombre arbitro
	 */
	public String getNombreArbitro() {
		return this.nombreArbitro;
	}
	
	/**
	 * Gets the dni territorio.
	 * 
	 * @return the dni territorio
	 */
	public String getDniTerritorio(){
		return this.dni+"__"+this.territorio;
	}	

	/**
	 * Sets the dni territorio.
	 * 
	 * @param dniTerritorio the new dni territorio
	 */
	public void setDniTerritorio(String dniTerritorio){
		String[] dniTerritorioArr = dniTerritorio.split("__");
		
		this.dni = dniTerritorioArr[0];
		this.territorio= dniTerritorioArr[1];
	}
	
}
